package sim.lib.functions;

import java.awt.*;

import sim.*;
import sim.engine.*;

import sim.lib.wires.Junction;

public class Negate extends Function1in1fatOut
{
/* ==================================================================
	Creation Part
	================================================================= */
	private static Image ICON = GuiFileLink.getImage("sim/lib/functions/NegateIcon.gif");
	
	public Image getIcon()
	{
		return Negate.ICON;
	}
	
	public String getBubbleHelp()
	{
		return "Negate";
	}
	
/* ==================================================================
	GUI part
	================================================================= */
	public Negate()
	{
		super();
	}
	
	protected Wrapper getCopy()
	{
		Negate result = new Negate();
		result.changeDelay(this.delay);
		result.setBusSize(this.busSize);
		return result;
	}
	
	public void paint(Graphics g)
	{
		// draw if visible
		if(this.isVisible())
		{
			int gridGap = CentralPanel.ACTIVE_GRID.getCurrentGridGap();
			int increment = gridGap / 4;
			
			g.setColor(this.brush);
			
			g.drawRect(0, gridGap, 2 * gridGap - 1, 2* gridGap - 1);
			
			g.fillRect(gridGap - 1, 0, 3, gridGap);
			g.fillRect(gridGap - 1, 3 * gridGap, 3, gridGap);
			
			g.setFont(new Font(Wrapper.FONT_NAME, Font.PLAIN, 3 * increment));
			
			FontMetrics fm = g.getFontMetrics(g.getFont());
			g.drawString("_", gridGap - fm.stringWidth("_") / 2, 2 * gridGap);//10 * increment);
		}
	}
	
/* ==================================================================
	Simulation part
	================================================================= */
	public void evaluateOutput(double currentTime, Data[] currentInputs, EnginePeer peer)
	{
		double time = this.delay + currentTime;
		
		int loop;
		int value = 0;
		int base = 1;
		boolean foundUndefined = false;
		String bitValue;
		
		for(loop = 0; (loop < this.busSize) && (!foundUndefined); loop++)
		{
			if(currentInputs[loop].isUndefined())
				foundUndefined = true;
			else if(currentInputs[loop].getValue())
				value = value + base;
			
			base = 2 * base;
		}
		
		if(foundUndefined)
		{
			for(loop = 0; loop < this.busSize;loop++)
				peer.setOutputPinUndefined(loop, time);
		}
		else
		{
			value = (int)Math.pow(2, this.busSize) - value;
			
			bitValue = Integer.toBinaryString(value);
			
			for(loop = bitValue.length(); loop <  this.busSize; loop ++)
				bitValue = "0" + bitValue;
			
			for(loop = 0; loop < this.busSize; loop++)
				peer.setOutputPinValue(loop, bitValue.charAt(bitValue.length() - 1 - loop) == '1', time);
		}
	}
}